/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.RenderInstrument;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class AEntityE_Interactable<JSONDefinition extends AJSONInteractableEntity>
extends AEntityD_Definable<JSONDefinition> {
    public static final int MAX_ENTITY_RADIUS = 150;
    private static final TransformationMatrix instrumentTransform = new TransformationMatrix();
    private static final RotationMatrix INSTRUMENT_ROTATION_INVERSION = new RotationMatrix().setToAxisAngle(0.0, 1.0, 0.0, 180.0);
    public final List<List<BoundingBox>> definitionCollisionBoxes = new ArrayList<List<BoundingBox>>();
    public final Set<BoundingBox> collisionBoxes = new HashSet<BoundingBox>();
    private final Map<JSONCollisionGroup, AnimationSwitchbox> collisionSwitchboxes = new HashMap<JSONCollisionGroup, AnimationSwitchbox>();
    public final BoundingBox encompassingBox = new BoundingBox(new Point3D(), new Point3D(), 0.0, 0.0, 0.0, false, null);
    public final Set<AEntityE_Interactable<?>> collidedEntities = new HashSet();
    public final List<ItemInstrument> instruments = new ArrayList<ItemInstrument>();
    public final List<List<RenderableData>> instrumentRenderables = new ArrayList<List<RenderableData>>();
    public final Map<JSONInstrument.JSONInstrumentComponent, RenderInstrument.InstrumentSwitchbox> instrumentComponentSwitchboxes = new LinkedHashMap<JSONInstrument.JSONInstrumentComponent, RenderInstrument.InstrumentSwitchbox>();
    public final Map<JSONInstrumentDefinition, AnimationSwitchbox> instrumentSlotSwitchboxes = new LinkedHashMap<JSONInstrumentDefinition, AnimationSwitchbox>();
    public static final String DAMAGE_VARIABLE = "damage";
    public final ComputedVariable damageVar;
    public final ComputedVariable towingConnectionVar;
    public final ComputedVariable playerCursorHoveredVar;
    public boolean outOfHealth;
    private final List<AEntityF_Multipart<?>> collidingMultiparts = new ArrayList();
    protected final List<Integer> snapConnectionIndexes = new ArrayList<Integer>();
    protected final Set<Integer> connectionGroupsIndexesInUse = new HashSet<Integer>();
    protected int lastSnapConnectionTried = 0;
    protected boolean bypassConnectionPacket;

    public AEntityE_Interactable(AWrapperWorld world, IWrapperPlayer placingPlayer, AItemSubTyped<JSONDefinition> item, IWrapperNBT data) {
        super(world, item, data);
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                this.instruments.add(null);
                this.instrumentRenderables.add(null);
            }
            for (JSONInstrumentDefinition packInstrument : ((AJSONInteractableEntity)this.definition).instruments) {
                if (packInstrument.animations == null) continue;
                ArrayList<JSONAnimationDefinition> animations = new ArrayList<JSONAnimationDefinition>(packInstrument.animations);
                this.instrumentSlotSwitchboxes.put(packInstrument, new AnimationSwitchbox(this, animations, packInstrument.applyAfter));
            }
            if (data != null) {
                for (int i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                    ItemInstrument instrument;
                    String instrumentPackID = data.getString("instrument" + i + "_packID");
                    String instrumentSystemName = data.getString("instrument" + i + "_systemName");
                    if (instrumentPackID.isEmpty() || (instrument = (ItemInstrument)PackParser.getItem(instrumentPackID, instrumentSystemName)) == null) continue;
                    this.addInstrument(instrument, i);
                }
            } else {
                for (JSONInstrumentDefinition packInstrument : ((AJSONInteractableEntity)this.definition).instruments) {
                    if (packInstrument.defaultInstrument == null) continue;
                    try {
                        String instrumentPackID = packInstrument.defaultInstrument.substring(0, packInstrument.defaultInstrument.indexOf(58));
                        String instrumentSystemName = packInstrument.defaultInstrument.substring(packInstrument.defaultInstrument.indexOf(58) + 1);
                        try {
                            ItemInstrument instrument = (ItemInstrument)PackParser.getItem(instrumentPackID, instrumentSystemName);
                            if (instrument == null) continue;
                            this.addInstrument(instrument, ((AJSONInteractableEntity)this.definition).instruments.indexOf(packInstrument));
                        }
                        catch (NullPointerException e) {
                            placingPlayer.sendPacket(new PacketPlayerChatMessage(placingPlayer, LanguageSystem.SYSTEM_DEBUG, "Attempted to add defaultInstrument: " + instrumentPackID + ":" + (String)instrumentSystemName + " to: " + ((AJSONInteractableEntity)this.definition).packID + ":" + ((AJSONInteractableEntity)this.definition).systemName + " but that instrument doesn't exist in the pack item registry."));
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        placingPlayer.sendPacket(new PacketPlayerChatMessage(placingPlayer, LanguageSystem.SYSTEM_DEBUG, "Could not parse defaultInstrument definition: " + packInstrument.defaultInstrument + ".  Format should be \"packId:instrumentName\""));
                    }
                }
            }
        }
        if (((AJSONInteractableEntity)this.definition).collisionGroups != null) {
            for (JSONCollisionGroup groupDef : ((AJSONInteractableEntity)this.definition).collisionGroups) {
                ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
                for (JSONCollisionBox boxDef : groupDef.collisions) {
                    boxes.add(new BoundingBox(boxDef, groupDef));
                }
                this.definitionCollisionBoxes.add(boxes);
                if (groupDef.animations == null && groupDef.applyAfter == null) continue;
                ArrayList<JSONAnimationDefinition> animations = new ArrayList<JSONAnimationDefinition>();
                if (groupDef.animations != null) {
                    animations.addAll(groupDef.animations);
                }
                this.collisionSwitchboxes.put(groupDef, new AnimationSwitchbox(this, animations, groupDef.applyAfter));
            }
        }
        this.lastSnapConnectionTried = 0;
        if (((AJSONInteractableEntity)this.definition).connectionGroups != null) {
            for (JSONConnectionGroup group : ((AJSONInteractableEntity)this.definition).connectionGroups) {
                if (!group.isSnap || !group.isHookup) continue;
                this.snapConnectionIndexes.add(((AJSONInteractableEntity)this.definition).connectionGroups.indexOf(group));
            }
        }
        this.damageVar = new ComputedVariable(this, DAMAGE_VARIABLE, data);
        this.addVariable(this.damageVar);
        this.towingConnectionVar = new ComputedVariable(this, "connection_requested", data);
        this.addVariable(this.towingConnectionVar);
        this.playerCursorHoveredVar = new ComputedVariable(this, "player_cursor_hovered");
        this.addVariable(this.playerCursorHoveredVar);
        this.outOfHealth = this.damageVar.currentValue == (double)((AJSONInteractableEntity)this.definition).general.health && ((AJSONInteractableEntity)this.definition).general.health != 0;
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("EntityE_Level", true);
        this.outOfHealth = this.damageVar.currentValue == (double)((AJSONInteractableEntity)this.definition).general.health && ((AJSONInteractableEntity)this.definition).general.health != 0;
        this.world.endProfiling();
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return !this.collisionSwitchboxes.isEmpty() || this.ticksExisted == 1L;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "damage_percent": {
                return new ComputedVariable(this, variable, partialTicks -> this.damageVar.currentValue / (double)((AJSONInteractableEntity)this.definition).general.health, false);
            }
            case "damage_totaled": {
                return new ComputedVariable(this, variable, partialTicks -> this.outOfHealth ? 1.0 : 0.0, false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    protected void updateCollisionBoxes(boolean requiresDeltaUpdates) {
        this.collisionBoxes.clear();
        if (((AJSONInteractableEntity)this.definition).collisionGroups != null) {
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).collisionGroups.size(); ++i) {
                AnimationSwitchbox switchBox;
                JSONCollisionGroup groupDef = ((AJSONInteractableEntity)this.definition).collisionGroups.get(i);
                List<BoundingBox> boxes = this.definitionCollisionBoxes.get(i);
                if (groupDef.health != 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(this.getOrCreateVariable((String)stringBuilder.append((String)"collision_").append((int)(i + 1)).append((String)"_damage").toString()).currentValue < (double)groupDef.health)) continue;
                }
                if ((switchBox = this.collisionSwitchboxes.get(groupDef)) != null) {
                    if (!switchBox.runSwitchbox(0.0f, false)) continue;
                    if (requiresDeltaUpdates) {
                        for (BoundingBox box : boxes) {
                            box.globalCenter.set(box.localCenter).transform(switchBox.netMatrix);
                            box.updateToEntity(this, box.globalCenter);
                        }
                    }
                } else if (requiresDeltaUpdates) {
                    for (BoundingBox box : boxes) {
                        box.updateToEntity(this, null);
                    }
                }
                this.collisionBoxes.addAll(boxes);
                if (this.world.isClient()) continue;
                if (groupDef.externalEntityDamage != 0.0f) {
                    for (BoundingBox box : boxes) {
                        IWrapperEntity controller = this instanceof AEntityF_Multipart ? ((AEntityF_Multipart)this).getController() : null;
                        LanguageSystem.LanguageEntry language = controller != null ? LanguageSystem.DEATH_HITBOX_PLAYER : LanguageSystem.DEATH_HITBOX_NULL;
                        Damage damage = new Damage(groupDef.externalEntityDamage, box, this, controller, language);
                        this.world.attackEntities(damage, null, false);
                    }
                }
                if (groupDef.internalEntityDamage == 0.0f) continue;
                this.performHitboxAttack(boxes, groupDef.internalEntityDamage);
            }
        }
    }

    private void performHitboxAttack(List<BoundingBox> boxes, float damage) {
        for (BoundingBox box : boxes) {
            this.collidingMultiparts.clear();
            this.world.populateWithEntitiesInBounds(this.collidingMultiparts, box);
            for (AEntityF_Multipart<?> multipart : this.collidingMultiparts) {
                if (multipart == this || multipart.allParts.contains(this)) continue;
                for (BoundingBox otherBox : multipart.allCollisionBoxes) {
                    if (!otherBox.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ATTACK) || !otherBox.intersects(box)) continue;
                    multipart.attack(new Damage(damage, otherBox, this, null, null));
                    return;
                }
            }
        }
    }

    protected void updateEncompassingBox() {
        this.encompassingBox.widthRadius = 0.0;
        this.encompassingBox.heightRadius = 0.0;
        this.encompassingBox.depthRadius = 0.0;
        for (BoundingBox box : this.collisionBoxes) {
            this.encompassingBox.widthRadius = (float)Math.max(this.encompassingBox.widthRadius, Math.abs(box.globalCenter.x - this.position.x) + box.widthRadius);
            this.encompassingBox.heightRadius = (float)Math.max(this.encompassingBox.heightRadius, Math.abs(box.globalCenter.y - this.position.y) + box.heightRadius);
            this.encompassingBox.depthRadius = (float)Math.max(this.encompassingBox.depthRadius, Math.abs(box.globalCenter.z - this.position.z) + box.depthRadius);
        }
        this.encompassingBox.updateToEntity(this, null);
    }

    public void damageCollisionBox(BoundingBox box, double damageAmount) {
        ComputedVariable variable = this.getOrCreateVariable("collision_" + (((AJSONInteractableEntity)this.definition).collisionGroups.indexOf(box.groupDef) + 1) + "_damage");
        double currentDamage = variable.currentValue + damageAmount;
        if (currentDamage > (double)box.groupDef.health) {
            double amountActuallyNeeded = damageAmount - (currentDamage - (double)box.groupDef.health);
            currentDamage = box.groupDef.health;
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(variable, amountActuallyNeeded));
            this.getOrCreateVariable("collision_" + (((AJSONInteractableEntity)this.definition).collisionGroups.indexOf(box.groupDef) + 1) + "_totaled").setActive(true, true);
        } else {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(variable, damageAmount));
        }
        variable.setTo(currentDamage, false);
    }

    @Override
    public void doPostUpdateLogic() {
        super.doPostUpdateLogic();
        this.world.beginProfiling("CollisionBoxUpdates", true);
        this.updateCollisionBoxes(this.requiresDeltaUpdates());
        this.updateEncompassingBox();
        this.world.endProfiling();
    }

    public void addInstrument(ItemInstrument instrument, int slot) {
        this.instruments.set(slot, instrument);
        ArrayList<RenderableData> renderables = new ArrayList<RenderableData>();
        for (JSONInstrument.JSONInstrumentComponent component : ((JSONInstrument)instrument.definition).components) {
            if (component.textObject != null) {
                renderables.add(null);
            } else {
                renderables.add(new RenderableData(RenderableVertices.createSprite(1, null, null)));
            }
            if (component.animations == null) continue;
            this.instrumentComponentSwitchboxes.put(component, new RenderInstrument.InstrumentSwitchbox(this, component));
        }
        this.instrumentRenderables.set(slot, renderables);
    }

    public void removeIntrument(int slot) {
        ItemInstrument removedInstrument = this.instruments.set(slot, null);
        if (removedInstrument != null) {
            for (JSONInstrument.JSONInstrumentComponent component : ((JSONInstrument)removedInstrument.definition).components) {
                this.instrumentComponentSwitchboxes.remove(component);
            }
            this.instrumentRenderables.set(slot, null);
        }
    }

    public final void handleCustomKeypress(byte keyIndex, boolean keyPressed) {
        if (((AJSONInteractableEntity)this.definition).customKeybinds != null) {
            ((AJSONInteractableEntity)this.definition).customKeybinds.forEach(customKeybind -> {
                if (customKeybind.keyIndex == keyIndex) {
                    this.performAction(customKeybind.action, keyPressed);
                    return;
                }
            });
        }
    }

    public void attack(Damage damage) {
        if (!(damage.isWater || damage.isExplosion && this.ignoreExplosiveDamage() || this.outOfHealth)) {
            double currentDamage = this.damageVar.currentValue + damage.amount;
            if (currentDamage > (double)((AJSONInteractableEntity)this.definition).general.health) {
                currentDamage = ((AJSONInteractableEntity)this.definition).general.health;
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this.damageVar, ((AJSONInteractableEntity)this.definition).general.health));
            } else {
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this.damageVar, damage.amount, 0.0, ((AJSONInteractableEntity)this.definition).general.health));
            }
            this.damageVar.setTo(currentDamage, false);
        }
    }

    public boolean ignoreExplosiveDamage() {
        return false;
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        this.collisionBoxes.forEach(box -> box.renderWireframe(this, transform, null, null));
    }

    @Override
    protected void renderModel(TransformationMatrix transform, boolean blendingEnabled, float partialTicks) {
        super.renderModel(transform, blendingEnabled, partialTicks);
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            this.world.beginProfiling("Instruments", true);
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                ItemInstrument instrument = this.instruments.get(i);
                if (instrument == null) continue;
                JSONInstrumentDefinition packInstrument = ((AJSONInteractableEntity)this.definition).instruments.get(i);
                instrumentTransform.set(transform);
                AnimationSwitchbox switchbox = this.instrumentSlotSwitchboxes.get(packInstrument);
                if (switchbox != null && !switchbox.runSwitchbox(partialTicks, false)) continue;
                if (switchbox != null) {
                    instrumentTransform.multiply(switchbox.netMatrix);
                }
                instrumentTransform.applyTranslation(packInstrument.pos);
                if (packInstrument.rot != null) {
                    instrumentTransform.applyRotation(packInstrument.rot);
                }
                instrumentTransform.applyRotation(INSTRUMENT_ROTATION_INVERSION);
                instrumentTransform.applyScaling(0.0625, 0.0625, 0.0625);
                RenderInstrument.drawInstrument(this, instrumentTransform, i, false, blendingEnabled, partialTicks);
            }
            this.world.endProfiling();
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                ItemInstrument instrument = this.instruments.get(i);
                if (instrument == null) continue;
                data.setString("instrument" + i + "_packID", ((JSONInstrument)instrument.definition).packID);
                data.setString("instrument" + i + "_systemName", ((JSONInstrument)instrument.definition).systemName);
            }
        }
        return data;
    }
}

